#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Zellij pattern 13 (music)Mod01.fsh   by  Jarble  
//https://www.shadertoy.com/view/Dt3SRs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 f1(vec2 a){
    return
        fract(a)
        //fract(a-fract(a*4.)/2.)
        //fract(a-floor(a.yx)/4.)
    ;
}

vec2 triangle_wave(vec2 a){
    vec2 a2 =
        vec2(1.,0.5)
        //-vec2(1.,0.5)
        //vec2(1.-sign(a.x)/2.,0.5+sign(a.x)/2.)
    ,
    a1 = a+a2;
    
    //another interesting pattern
    //if(a.x>a.y) a2 = -vec2(.5,1.5);
    
    return
        abs(f1((a1)*(a2.x+a2.y))-.5)
    ;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor = vec4(0.0);
    vec3 col = vec3(0.);
    float t1 = 1.;
    vec2 uv = (fragCoord)/iResolution.x/t1/2.0;
    uv.y += (iTime/2.0,iTime/3.0)/t1/8.0;
    if(iMouse.z>.5)
    uv = uv.xy + iMouse.xy / iResolution.xy/t1;
    vec2 t2 = vec2(0.);
    bool b = true;
    uv.y = mod(uv.y,.5)+.25;
    uv.x = mod(uv.x,.5)+.25;
    for(int k = 0; k < 6; k++){
        uv =
            abs(.5-uv-t2)/1.5
            //abs(-.5*sign(uv.y-uv.x)-uv-t2)/1.5
        ;
        
        //remove the red border around the zellij pattern
        uv = abs(fract(vec2(uv+vec2(.5,1.5))*3.)-.5)/3.;

        //uv.y -= .5;
        b =
            uv.y<uv.x
            //uv.y<uv.x||t2.y<t2.x&&!b
        ;
        if(b)
            uv = uv.yx
            //uv.x += .5
            //uv.y += .5
        ;
        t2 =
            triangle_wave(uv-.5).yx
            //triangle_wave(uv-.5+floor(.5+t2.y+t2.x)).yx
        ;
        uv =
            t2-triangle_wave(uv.yx).yx*sign(.5-uv.y)
        ;
        vec2 t21 =
            //triangle_wave(t2)
            t2
        ;
        col.x =
            max((t21.y+t21.x),col.x)
            //max(abs(t2.y+t2.x),1.-col.x)
        ;
        col =
            abs(col-1.+col.x)
            //vec3(col.zx,max(uv.x-uv.y,col.y))
            //max((col-1.+col.x/1.5),(1.-col-col.yzx))
        ;
    }
    if (!b) col = abs(1.-col);
    fragColor = vec4(min(col,vec3(1.)),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

